/*
	Note: the use of 'tail' in the comments refers to the end of what would be conceived as the snakes 
	actual tail. Just the tip, if you will.
			
	So:
	We have the snake array with which we can iterate through properly, and we hold all other 
	information in the grid (such as corners, where the snake currently is, so we don't collide into it, etc)

	Methinks I need to hold a value in the grid whch notes if there is part of a snake there.
	That way I wont need to loop through the snake array twice.
*/

var dir="u", new_dir, op_dir, cont, snake, apple, exit, exit_pos = null, snake_move, isPaused = false, can_change = true, game_started = false;
var score = 0, score_inc, score_divider, exit_int, speed, max_apples, max_time, time_elapsed, old_panel = null, game_type = "2004", new_game_type, difficulty = "easy", new_difficulty, time_bar, lives;
	
var classic_high = classic_most = modern_high = modern_most = 0;
	
var start_pos_x, start_pos_y, start_dir, walls;

var num_eaten_apples, cur_level = 1;
	
var grid_block_size = 8; //size of each block in the grid, funnily enough
var grid_height = 17;
var grid_width = 30; //how many blocks in the grid (height- and width-wise)
var grid = new Array(); //the grid through which the snake moves, apples are appended, etc
	
speed = 100; //going to be set in setLevel() instead of here
	
var body_start_length = 7; //how many body parts to create the snake with initially (includes head and tail)
var head_pos_x, head_pos_y, tail_pos_x, tail_pos_y; //keeping a running track of where the head and tail are :)
	
var snake_array; // = new Array(body_start_length);
	
/* 
   just preloading the images so there's no flicker at the start...
   should probably use these objects rather than saying explicitly each time.
   Ah well - can't be bothered at the moment...
*/

var pre_img = new Image();
var img_ar = [  "ui/snake_body_d.png",
                "ui/snake_body_l.png",
                "ui/snake_body_r.png",
                "ui/snake_body_u.png",
                "ui/snake_curve_bl.png",
                "ui/snake_curve_br.png",
                "ui/snake_curve_tl.png",
                "ui/snake_curve_tr.png",
                "ui/snake_head_d.png",
                "ui/snake_head_l.png",
                "ui/snake_head_r.png",
                "ui/snake_head_u.png",
                "ui/snake_tail_d.png",
                "ui/snake_tail_l.png",
                "ui/snake_tail_r.png",
                "ui/snake_tail_u.png"];
for (var i=0; i < img_ar.length; i++) pre_img.src = img_ar[i];
	
function part(x, y, part_type, dir, changed_dir, el) {
	this.x = x;
	this.y = y;
	this.part_type = part_type; //head, body-part, tail, apple
	this.dir = dir;
	this.changed_dir = changed_dir || false; //tells whether to switch the image or not
	this.el = el; //the element at this position;
}

/* now, a block is part of the wall, a corner or part of the snake.
   This is used solely so that I don't have to loop through the snake array multiple time.
   It should also allow for scalability if there's any feature changes.
	   
   I've used block because of 'a block' and two because these are things that block
   the snake (either by losing or by changing direction).
 */
	 
 function block(kind, corner_dir) {
 	this.kind = kind; //w for wall, s for snake (part), a for apple and c for corner. There's no real reason for differentiating the first three, except to make it a wee bit easier to read/understand...
 	this.corner_dir = corner_dir || false;
 }
	
function createSnake() {
    var init_left = start_pos_x; //Math.floor(grid_width/2);
    var init_top = start_pos_y; //Math.floor((grid_height-body_start_length)/2);
    
    cont = document.getElementById("board");

    cont.innerHTML = ""; //easy way out - should probs use the DOM instead...

    cont.style.width = grid_block_size*grid_width + "px";
    cont.style.height = grid_block_size*grid_height + "px";
    
    snake_array = new Array(body_start_length);
    
    var x_dif = 0;
    var y_dif = 0;
    var h_img, b_img, t_img;
    
    dir = start_dir;
    
    switch (start_dir) {
        case "u": //up
            y_dif = 1;
            h_img = "snake_head_u";
            b_img = "snake_body_u";
            t_img = "snake_tail_u";
            break;
        case "d": //down
            y_dif = -1;
            h_img = "snake_head_d";
            b_img = "snake_body_d";
            t_img = "snake_tail_d";
            break;
        case "l": //left
            x_dif = 1;
            h_img = "snake_head_l";
            b_img = "snake_body_l";
            t_img = "snake_tail_l";
            break;
        case "r": //right
            x_dif = -1;
            h_img = "snake_head_r";
            b_img = "snake_body_r";
            t_img = "snake_tail_r";
            break;		
    }
			
    for (var i=0; i < body_start_length; i++) {
        var top_pos = init_top + (i*y_dif);
        var left_pos = init_left + (i*x_dif);

        var snake_bod = document.createElement("DIV");
        snake_bod.className = "snake_bod";
        
        snake_bod.style.left = (left_pos*grid_block_size) + "px";
        snake_bod.style.top = (top_pos*grid_block_size) + "px";
        snake_bod.style.width = grid_block_size + "px";
        snake_bod.style.height = grid_block_size + "px";

        if (i % (body_start_length-1)) { // the body pieces
            snake_array[i] = new part(left_pos, top_pos, "b", start_dir, null, snake_bod);
            snake_bod.style.backgroundImage = "url(ui/" + b_img + ".png)";
        } else {
            if (i == 0) { //head
                snake_array[i] = new part(left_pos, top_pos, "h", start_dir, null, snake_bod);
                snake_bod.style.backgroundImage = "url(ui/" + h_img + ".png)";
                head_pos_x = left_pos;
                head_pos_y = top_pos;
            } else { //tail
                snake_array[i] = new part(left_pos, top_pos, "t", start_dir, null, snake_bod);
                snake_bod.style.backgroundImage = "url(ui/" + t_img + ".png)";
                tail_pos_x = left_pos;
                tail_pos_y = top_pos;
            }	
            grid[top_pos][left_pos] = new block('s');
        }

        cont.appendChild(snake_bod);	
    }

    //we're going to create the exit, so we have a reference to it:
    
    exit = document.createElement("DIV");
    exit.className = "exit";

    exit.style.width = grid_block_size + "px";
    exit.style.height = grid_block_size + "px";
    
    cont.appendChild(exit);
    
    createApple();
    startGame();
}
	
function createApple() { //there's two reasons for using the term apple, can you guess what they are? ;)
//apples get appended to the grid (as do corners)
    var apple_top = Math.floor(Math.random()*grid_height);
    var apple_left = Math.floor(Math.random()*grid_width);
    
    var can_place_apple = true;
    
    for (var i=0; i < snake_array.length; i++) {
        //so putting a little box round it, so that there's definitely no chance of an apple being placed on the body, and making sure it's not on part of the maze
        if ((apple_top >= (snake_array[i].y-1) && apple_top <= (snake_array[i].y+1)) && (apple_left >= (snake_array[i].x-1) && apple_left <= (snake_array[i].x+1)) || (grid[apple_top][apple_left] != null && grid[apple_top][apple_left].kind == "w")) {
            can_place_apple = false;
            break;
        }	
    }
    
    if (!can_place_apple) { //can't go there. try again
        createApple();
    } else {
        apple = document.createElement("DIV");
        apple.className = "apple";

        apple.style.left = (apple_left*grid_block_size) + "px";
        apple.style.top = (apple_top*grid_block_size) + "px";
        apple.style.width = grid_block_size + "px";
        apple.style.height = grid_block_size + "px";
        
        grid[apple_top][apple_left] = new block('a'); //new part(apple_left, apple_top, "a", null, null, apple);

        cont.appendChild(apple);
    }
}
	
function moveApple() {
    //very similar to the above, except we're just moving the apple round, so no need to actually create it.
    //could be part of the above function, but it isn't (for now, at least) :)

    //also, change level depending on how many apples we've eaten.
    num_eaten_apples++;
    
    if (game_type == "2004" && num_eaten_apples == (max_apples-cur_level)) {
        apple.style.display = "none";
        showExit();
    } else {
        var apple_top = Math.floor(Math.random()*grid_height);
        var apple_left = Math.floor(Math.random()*grid_width);
        
        var can_place_apple = true;
        
        for (var i=0; i < snake_array.length; i++) {
            //so putting a little box round it, so that there's definitely no chance of an apple being placed on the body, and making sure it's not on part of the maze
            if ((apple_top >= (snake_array[i].y-1) && apple_top <= (snake_array[i].y+1)) && (apple_left >= (snake_array[i].x-1) && apple_left <= (snake_array[i].x+1)) || (grid[apple_top][apple_left] != null && grid[apple_top][apple_left].kind == "w")) {
                can_place_apple = false;
                break;
            }	
        }
			
        if (!can_place_apple) { //can't go there. try again
            num_eaten_apples--;
            moveApple();
        } else {
            apple.style.left = (apple_left*grid_block_size) + "px";
            apple.style.top = (apple_top*grid_block_size) + "px";
            
            grid[apple_top][apple_left] = new block('a'); //new part(apple_left, apple_top, "a", null, null, apple);
            
            //and extend the body too:
            addBodyParts(1);
        }
    }
				
    if (game_type == "classic") {
        score += Math.ceil(((time_elapsed/1000)*num_eaten_apples)/score_divider);
        writeString("num_apples", ""+num_eaten_apples, "grey");
        writeString("info","score: " + score, "grey");
    } else {
        score += Math.ceil((parseInt(time_bar.style.width)*cur_level)/score_divider);
        if (score%10000 == 0 && lives < 9) lives++;
        
        document.getElementById("num_apples").getElementsByTagName("IMG")[num_eaten_apples-1].src = "ui/display_applecount_on.png";
        writeString("info","level: " + cur_level + " score: " + score, "grey");
    }
}

function showExit() {
    exit.style.display = "block";

    //so we get a random side:
    
    var exit_along, exit_side = Math.floor(Math.random()*4);
    var exit_top = exit_left = 0;
    var shift_left = shift_top = 0; 
    var can_place_exit = true;
    var img = "ui/escape_"
    
    if (exit_side%2 == 0) { //top or bottom (respectively)
        exit_along = Math.floor(Math.random()*grid_width);
        if (exit_side == 0) {
            shift_top = 1;
            exit_top = 0;
            img += "up.gif";
        } else {
            shift_top = -1;
            exit_top = grid_height-1; //exit_side * (grid_height-1);
            img += "down.gif";
        }
        exit_left = exit_along;	
    } else { //left or right (respectively)
        exit_along = Math.floor(Math.random()*grid_height);
        if (exit_side == 2) {
            shift_left = 1;
            exit_left = 0;
            img += "left.gif";
        } else {
            shift_left = -1;
            exit_left = grid_width-1; //exit_along * (grid_width-1);
            img += "right.gif";
        }
        exit_top = exit_along;
    }
    
    if (grid[exit_top][exit_left] != null && grid[exit_top][exit_left].kind == "w") {
        can_place_exit = false;
    }
    
    if (!can_place_exit) { //can't go there. try again
        return showExit();
    } else {
        exit.style.left = (exit_left*grid_block_size) + "px";
        exit.style.top = (exit_top*grid_block_size) + "px";
        exit.style.backgroundImage = "url(" + img + ")";
        
        exit_pos = new pos(exit_top-shift_top, exit_left-shift_left);
        
        exit_int = setTimeout("showExit()", 10000);
    }
}
	
function pos(top, left) {
    this.top = top;
    this.left = left;	
}
	
function moveSnake() { //moves all the snake parts	
    for (var i=0; i < snake_array.length; i++) {
        //var old_left = left = snake_array[i].x;
        //var old_top = top = snake_array[i].y; <---- safari doesn't like this - WTF?! WHY?!?!
        
        var left = snake_array[i].x;
        var old_left = left;
        var top = snake_array[i].y;
        var old_top = top;
                
        var cur_dir = null;
        var img = "";

        var eaten_apple = false;
        
        if (grid[top][left] != null && grid[top][left].kind == "c") {
            //kind of a wee switchy thing going on so i can remove the corners when the tail goes through... not too sure about how good a method it is, but...
                cur_dir = grid[top][left].corner_dir;
                if (snake_array[i].dir != cur_dir) {
                    snake_array[i].changed_dir = true; //see below for why this is being done
                    if (i == (snake_array.length-1)) grid[top][left] = null;
                }
                
                snake_array[i].dir = cur_dir;
        }
        
        var direction = snake_array[i].dir;
        var part_type = snake_array[i].part_type;
        var has_changed = snake_array[i].changed_dir;
			
        switch (direction) {
            case "u": //up
                top--;
                if (has_changed) { //as with below, this is for a wee bit of extra performance
                    switch (part_type) {
                        case "h":
                            img = "snake_head_u";
                            break;
                        case "b":
                            img = "snake_body_u";
                            break;
                        case "t":
                            img = "snake_tail_u";
                            break;
                    }
                }
                break;
            case "d": //down
                top++;
                if (has_changed) {
                    switch (part_type) {
                        case "h":
                            img = "snake_head_d";
                            break;
                        case "b":
                            img = "snake_body_d";
                            break;
                        case "t":
                            img = "snake_tail_d";
                            break;
                    }
                }
                break;
            case "l": //left
                left--;
                if (has_changed) {
                    switch (part_type) {
                        case "h":
                            img = "snake_head_l";
                            break;
                        case "b":
                            img = "snake_body_l";
                            break;
                        case "t":
                            img = "snake_tail_l";
                            break;
                    }
                }
                break;
            case "r": //right
                left++;
                if (has_changed) {
                    switch (part_type) {
                        case "h":
                            img = "snake_head_r";
                            break;
                        case "b":
                            img = "snake_body_r";
                            break;
                        case "t":
                            img = "snake_tail_r";
                            break;
                    }
                }
                break;
        }
			
        if (i == 0) {
            head_pos_x = left;
            head_pos_y = top;
            
        //colliding with the sides:
            if (head_pos_x < 0 || head_pos_x >= grid_width || head_pos_y < 0 || head_pos_y >= grid_height) {
                if (exit_pos != null) {
                    if (head_pos_x == exit_pos.left && head_pos_y == exit_pos.top) {
                        exit_pos = null;
                        clearTimeout(exit_int);
                        pauseGame(false);
                        setLevel(++cur_level);
                    } else {
                        endGame(true);
                    }
                } else {
                    endGame(true);
                }
                return;
            }
        //colliding with itself or parts of the maze:
        //quick point: despite differentiating between corners and snake parts, corners are _always_ part of the snake, so maybe the distinction shouldn't be made...
            if (grid[head_pos_y][head_pos_x] != null && (grid[head_pos_y][head_pos_x].kind != "a") && (grid[head_pos_y][head_pos_x].kind != "c")) { // || grid[head_pos_y][head_pos_x].kind == "w")) { 
                //alert(grid[head_pos_y][head_pos_x].toSource());
                endGame(true);
                return;
            }
            
        //eating an apple	
            if (grid[top][left] != null && grid[top][left].kind == "a") {
                //moveApple();
                eaten_apple = true;
                grid[top][left] = null;
            }
        }
        
        if (i == snake_array.length-1) {
            tail_pos_x = left;
            tail_pos_y = top;	
            
            //now remove where the snake part is from the grid array..
            if (grid[old_top][old_left] != null && grid[old_top][old_left].kind == "s") grid[old_top][old_left] = null;	
        }
			
        snake_array[i].x = left;
        snake_array[i].y = top;
        snake_array[i].el.style.top = (top*grid_block_size) + "px";
        snake_array[i].el.style.left = (left*grid_block_size) + "px";			

        if (eaten_apple) moveApple();

        //now update where the snake is in the grid (making sure we're not over-writing a corner or anything):
        if (grid[top][left] == null) grid[top][left] = new block('s');

        
        //we've moved, but we need to check if we're moving into a corner, and change accordingly
        if (grid[top][left] != null && (grid[top][left].kind == "c" || has_changed)) { //so obviously, we're trying to squeeze out as much performance as possible. only changing the backgroundImage when it needs to be... (obvious point, but one worth making, I feel)
            switch (grid[top][left].corner_dir) {
                case "u": //up
                    if (i == snake_array.length-1) {
                        img = "snake_tail_u";
                    } else {
                        img = (direction == "l") ? "snake_curve_bl" : "snake_curve_br";
                    }
                    break;
                case "d": //down
                        if (i == snake_array.length-1) {
                            img = "snake_tail_d";
                        } else {
                            img = (direction == "l") ? "snake_curve_tl" : "snake_curve_tr";
                        }
                    break;
                case "l": //left
                        if (i == snake_array.length-1) {
                            img = "snake_tail_l";
                        } else {
                            img = (direction == "u") ? "snake_curve_tr" : "snake_curve_br";
                        }
                    break;
                case "r": //right
                        if (i == snake_array.length-1) {
                            img = "snake_tail_r";
                        } else {
                            img = (direction == "u") ? "snake_curve_tl" : "snake_curve_bl";
                        }
                    break;	
            }
            snake_array[i].el.style.backgroundImage = "url(ui/" + img + ".png)";
        }
        
        //so now, if changed_dir is set to true (we've gone into a corner), we want to remove it after we've moved one past it.
        if (snake_array[i].changed_dir && grid[top][left].part_type != "c") snake_array[i].changed_dir = false;
    }		
    can_change = true;
		
    //and so we increment the time here (rather than running another timer)
    time_elapsed += speed;
    
    if (game_type == "2004") {
        if (time_elapsed >= (max_time*1000)) {
            endGame(true);
        } else {
            time_bar.style.width = Math.floor(100 - ((time_elapsed/(max_time*1000))*100)) + "%";
        }
    }
}
	
function addBodyParts(num) {		
        var tail_dir = snake_array[snake_array.length-1].dir;

        var top_change = left_change = 0;
        
        switch (tail_dir) {
            case "u": //up
                top_change = 1;
                break;
            case "d": //down
                top_change = -1;
                break;
            case "l": //left
                left_change = 1;
                break;
            case "r": //right
                left_change = -1;
                break;	
        }
        
        for (var i=1; i <= num; i++) {
            var snake_bod = document.createElement("DIV");
            snake_bod.className = "snake_bod";
            
            snake_bod.style.width = grid_block_size + "px";
            snake_bod.style.height = grid_block_size + "px";
        
            cont.appendChild(snake_bod);
            
            snake_array.splice(snake_array.length-1, 0, new part(tail_pos_x, tail_pos_y, "b", tail_dir, true, snake_bod));
        
            var el = snake_array[snake_array.length-2];
            //need to find the direction of the tail:
            if (i > 1) { //so the first one doesn't change, just takes the tails old position
                el.x = el.x + (left_change*(i-1));
                el.y = el.y + (top_change*(i-1));
            }
            el.el.style.left = (el.x*grid_block_size) + "px";
            el.el.style.top = (el.y*grid_block_size) + "px";
            
            if (grid[el.y][el.x].corner_dir == false) grid[el.y][el.x] = new block('s'); //the condition is so that we don't get rid of necessary corners (if the tail is on a corner when an apple is eaten....)
        }
        
         snake_array[snake_array.length-1].x = snake_array[snake_array.length-2].x + left_change;
         snake_array[snake_array.length-1].y = snake_array[snake_array.length-2].y + top_change;
}

function handleKeyPress(e) {
    
    /* should probably hold all the keys pressed in an array, and then as we move forward it'll do
       the next move (change direction) specified in the array. Maybe not though - if they do it too quick, then never mind ;)
     */

    if (!isPaused && can_change) { //stops it doubling back too fast and running into itself - will change when i let it advance more smoothly!
    var cur_dir = snake_array[1].dir;
        switch (e.keyCode) {
            case 37:
                if (dir != "r") new_dir = "l";
                op_dir = "r"; //used in the current method of stopping you from doubling back on yourself and dying...
                break;
            case 38:
                if (dir != "d") new_dir = "u";
                op_dir = "d";
                break;
            case 39:
                if (dir != "l") new_dir = "r"; 
                op_dir = "l";
                break;
            case 40:
                if (dir != "u") new_dir = "d"; 
                op_dir = "u";
                break;
        }
        
        if (e.keyCode >= 37 && e.keyCode <= 40) { //otherwise, pressing any key will place a corner, but not an actual one with a dir - big problem!
            if (op_dir != snake_array[0].dir) {
                dir = new_dir; //so it isn't doubling back on itself...
                if (dir != snake_array[0].dir) grid[head_pos_y][head_pos_x] = new block("c", dir);
                new_dir = null;
                
                can_change = false;
                //setTimeout(function(){can_change=true;}, 50); //this is _not_ an ideal solution - i'll rework this when i have time. but for now it works. they're free! what else do you want?! ;)
            }
            //make sure the user has pressed a different direction to the one the snake is already travelling in:
            //if (dir != snake_array[0].dir) grid[head_pos_y][head_pos_x] = new block("c", dir);
        }
    }
    
    if (e.keyCode == 80) pauseGame(true); //not in the switch for obvious reasons
}

//Functions not related specifically to game play:
	
function pauseGame(show) {
    if (!isPaused) {
        clearInterval(snake_move);
        if (show) document.getElementById("pause_game").style.display = "block";
        isPaused = true;			
    } else {
        snake_move = setInterval("moveSnake()", speed);
        if (show) document.getElementById("pause_game").style.display = "none";
        isPaused = false;
    }
}
	
function startGame() {
    //do the little countdown, then start the game:
    document.removeEventListener("keydown", handleKeyPress, false);
    isPaused = false;	
    var c = document.getElementById("count_down");
    c.src = "ui/countdown/3.png";
    c.style.opacity = "1.0";
    setTimeout(function() {
                countDown(c);
                //document.addEventListener("keydown", handleKeyPress, false);
                //makeMaze(); //createSnake();
            }, 500);
}
	
//obviously a rather longwinded solution to the count down at the beginning of the game/levels

function countDown(what) {
    var dif, opac;
    opac = 1.0;
    dif = 0.1;
    what.style.opacity = "1.0";
    what.style.display = "block";
  
    var fader = setInterval(function() {
                   opac -= dif;
                   if (opac >= 0.1) {
                          what.style.opacity = opac;  
                   } else {
                      clearInterval(fader);
                      if (what.src.indexOf("3.png") != -1) {
                              what.src = "ui/countdown/2.png";
                              what.style.display = "none";
                              //what.style.opacity = "1.0";
                              setTimeout(function(){countDown(what);}, 300);
                        } else if (what.src.indexOf("2.png") != -1) {
                              what.src = "ui/countdown/1.png";
                              what.style.display = "none";
                              //what.style.opacity = "1.0"; 
                              setTimeout(function(){countDown(what);}, 300);
                        } else if (what.src.indexOf("1.png") != -1) {
                              what.src = "ui/countdown/0.png";
                              what.style.display = "none";
                              //what.style.opacity = "1.0"; 
                              setTimeout(function(){countDown(what);}, 300);
                        } else if (what.src.indexOf("0.png") != -1) {
                              what.style.display = "none";
                              document.addEventListener("keydown", handleKeyPress, false);
                            snake_move = setInterval("moveSnake()", speed);
                            game_started = true;
                        }
                      
                   }
                  }, 50);
}
		
function fadeIn(what) {
	var dif, opac;
    opac = 0.0;
    dif = 0.1;
	      
    what.style.opacity = opac;
    what.style.display = "block";
	  
    var fader = setInterval(function() {
		                   if (opac <= 1) {
		                      what.style.opacity = opac;
		                      opac += dif;
		                   } else {
		                      clearInterval(fader);
		                   }
	                  }, 50);
}

function fadeOut(what) {
    var dif, opac;
    opac = 1.0;
    dif = 0.1;
		  
    var fader = setInterval(function() {
                                if (opac > 0.1) {
                                    what.style.opacity = opac;
                                    opac -= dif;
                                } else {
                                    what.style.display = "none";
                                    clearInterval(fader);
                                }
                            }, 50);
}


function endGame(died) {
    clearInterval(snake_move);
    clearInterval(exit_int); //just incase :/

    document.removeEventListener("keydown", handleKeyPress, false);
    var end_game = document.getElementById("end_game");
    
    if (died) {
        if (game_type == "2004") {
            lives--;
            if (lives > 0) {
                end_game.style.backgroundImage = "url(ui/panels/lives_" + lives + ".png)";
                end_game.setAttribute("onclick","this.style.display='none'; setLevel(" + cur_level + ")");
            } else {
                end_game.style.backgroundImage = "url(ui/panels/lose.png)";
                end_game.setAttribute("onclick","this.style.display='none'; setLevel(1)");
                if (score > modern_high) modern_high = score;
                if (cur_level > modern_most) modern_most = cur_level;
                setDifficulty(difficulty); //basically just needed to reset the number of lives, but may as well do it all...
            }
        } else {
            end_game.style.backgroundImage = "url(ui/panels/old_timer_rant.png)";
            end_game.setAttribute("onclick","this.style.display='none'; setLevel(1)");
            if (score > classic_high) classic_high = score;
            if (num_eaten_apples > classic_most) classic_most = num_eaten_apples;
            score = 0; //yes, all of this should be handled differently - need to read back through the code.
        }
    } else { //they've completed the game!
        end_game.style.backgroundImage = "url(ui/panels/win_" + difficulty + "play.png)";
    }
    end_game.style.display = "block";
    
    //always going to set the highscore stuff, even if they haven't changed :/
    //this means even if they quit halfway through 2004, as long as they finished the
    // (i.e. lost a life) then it'll keep their score...
    if (window.widget) {
        widget.setPreferenceForKey(classic_high, "classic_high");
        widget.setPreferenceForKey(classic_most, "classic_most");
        widget.setPreferenceForKey(modern_high, "modern_high");
        widget.setPreferenceForKey(modern_most, "modern_most");
    }
    
    game_started = false;
}
	
function setDifficulty(dif) {
    switch (dif) {
        case "easy":
            speed = 150;
            max_apples = 21;
            max_time = 110;
            lives = 6;
            score_divider = 4;
            break;
        case "hard":
            speed = 100;
            max_apples = 19;
            max_time = 70;
            lives = 5;
            score_divider = 2;
            break;
        case "insane":
            speed = 50;
            max_apples = 17;
            max_time = 40;
            lives = 4;
            score_divider = 1;
            break;
    }
}
	
var level_xml;

function setLevel(level) {
    if (level <= 16) {
    document.getElementById("start_game").style.display = "none";

        level_xml = new XMLHttpRequest();
        var url = "ui/levels/level" + level + ".xml";
        level_xml.open("GET", url, true);
        level_xml.onreadystatechange = responseHandler;            
        level_xml.send(null);
            
        if (level > 1) {
            document.getElementById("board").style.backgroundImage = "url(ui/levels/" + level + ".gif)";
        } else {
            document.getElementById("board").style.backgroundImage = "";
        }
        
        var num_apples = document.getElementById("num_apples");
        num_apples.innerHTML = "";

        if (level == 1 && lives == 0) score = 0;

        if (game_type == "2004") {
            for (var i=0; i < (max_apples-level); i++) {
                var img = document.createElement("IMG");
                img.src = "ui/display_applecount_off.png";
                img.style.marginLeft = "2px";
                num_apples.appendChild(img);
                
                writeString("info","level: " + level + " score: " + score, "grey");
            }
        } else {
            writeString("info","score: " + score, "grey");
            writeString("num_apples", "0", "grey");	
        }

        var p = document.getElementById("pause_game"); 
        if (p.style.display != "none") {
            p.style.display = "none";
        }
        
        cur_level = level; //only necessary when replaying... should probs rethink this :/
        
        time_bar.style.width = "100%";
        time_elapsed = 0;
    } else {
        endGame(false); //won the game!
    }
}
       
function responseHandler() {
    if (level_xml.readyState == 4) {
            //if (hs.status == 200) { //removed this because it doesn't seem to want to work when we make two requests ina page session... weird.

    //resetting the grid:                
        grid = new Array(grid_height);
        for (var i=0; i < grid_height; i++) {
            grid[i] = new Array(grid_width);
            for (var a=0; a < grid_width; a++) grid[i][a] = null;
        }
    //resetting the other variables:
        num_eaten_apples = 0;
        new_dir = null;
        op_dir = null;
    
        head_pos_x = null;
        head_pos_y = null;
        tail_pos_x = null;
        tail_pos_y = null;
    
        snake_array = new Array(body_start_length);

        level_data = level_xml.responseXML;
                
        //the start parameters
        var start_params = level_data.getElementsByTagName("start");
           start_pos_x = parseInt(start_params[0].getAttribute("left"));
        start_pos_y = parseInt(start_params[0].getAttribute("top"));

        start_dir = start_params[0].getAttribute("direction");
    
        var blocks = level_data.getElementsByTagName("block");

        for (var i=0; i < blocks.length; i++) {
            var top = blocks[i].getAttribute("top");
            var left = blocks[i].getAttribute("left");
            grid[top][left] = new block('w');
        }
                
        createSnake();
    }
}
        
function toggleSettings() {
    var p = document.getElementById("settings");
           
    if (p.style.display != "block") {
        writeString("classic_high", "high score: " + classic_high, "white");
        writeString("classic_most", "most apples: " + classic_most, "white");
        writeString("modern_high", "high score: " + modern_high, "white");
        writeString("modern_most", "highest level: " + modern_most, "white");
                                    
        if (game_started) {		   		
            if (!isPaused) {
                pauseGame(false);
            }
            clearPanels(true);			   		
            document.removeEventListener("keydown", handleKeyPress, false);
        }

        fadeIn(p);
    } else {
        fadeOut(p);
        if (old_panel != null) {
            fadeIn(old_panel);
            old_panel = null;
        }
               
        if (new_game_type != game_type || new_difficulty != difficulty) {
            doneSettings();
        }
               
        if (isPaused && old_panel != null && old_panel.id != "pause_game") pauseGame(false);
               
        document.addEventListener("keydown", handleKeyPress, false);
    }
}
       
function doneSettings() {
    if (new_difficulty != difficulty) {
        difficulty = new_difficulty;
        if (window.widget) widget.setPreferenceForKey(difficulty, "difficulty");
        setDifficulty(difficulty);
    }
           
    if (new_game_type != game_type) {
        game_type = new_game_type;
        if (window.widget) widget.setPreferenceForKey(game_type, "game_type");
    }
           
    //and now restart the game:
    cur_level = 1;
    score = 0;
    setLevel(1);
    document.getElementById("end_game").style.display = "none"; //incase it was present :/
}
   		
function writeString(target, str, colour) {
    target = document.getElementById(target);
    target.innerHTML = "";
    str.toLowerCase();
           
    for (var i=0; i < str.length; i++) {
        var chr = str.charAt(i);
        var img = document.createElement("IMG");
        var src;
               
        switch(chr) {
            case "\"":
                src = "minute.gif";
                break;
            case "'":
                src = "second.gif";
                break;
            case ":":
                src = "hyphen.gif";
                break;
            case " ":
                img = " ";
                break;
            default:
                src = chr + ".gif";
        }
               
        if (img == " ") {
            img = document.createTextNode(' ');
        } else {
            img.src = "ui/characters/" + colour + "/" + src;
        }
        target.appendChild(img);
    }
}

function clearPanels(fade) {
    var d = document.getElementsByTagName("DIV");
    for (var i=0; i < d.length; i++) {
        if (d[i].className == "pane") {
            if (d[i].style.display == "block") {
                old_panel = d[i];
                (fade) ? fadeOut(d[i]) : d[i].style.display = "none";
            }
        }
    }
}
		
function selectSetting(e) {
    e = e.target;
    var imgs = e.parentNode.childNodes;
    for (var i=0; i < imgs.length; i++) {
        if (imgs[i].nodeType == 1 && imgs[i].tagName == "IMG") {
            var src = imgs[i].src;
            var tmp = src.split("_");

            src = tmp[0] + "_";
            if (imgs[i].parentNode.id != "game_type") src += tmp[1] + "_";

            src += (imgs[i] == e) ? "selected.gif" : "norm.gif";

            imgs[i].src = src;
        }
    }
}
		
function init() {
    document.getElementById("start_game").style.display = "block";
    var dif = document.getElementById("difficulty");
    var typ = document.getElementById("game_type");
        
    dif.addEventListener("click", selectSetting, true);
    typ.addEventListener("click", selectSetting, true);
        
    //get user preferences:
    if (window.widget) {
        difficulty = widget.preferenceForKey("difficulty") || "easy";
        game_type = widget.preferenceForKey("game_type") || "2004";
        classic_high = widget.preferenceForKey("classic_high") || 0;
        classic_most = widget.preferenceForKey("classic_most") || 0;
        modern_high = widget.preferenceForKey("modern_high") || 0;
        modern_most = widget.preferenceForKey("modern_most") || 0;
    }
        
    switch(difficulty) {
        case "easy":
            dif.getElementsByTagName("IMG")[0].src = "ui/settings/mode_easy_selected.gif";
            break;
        case "hard":
            dif.getElementsByTagName("IMG")[1].src = "ui/settings/mode_hard_selected.gif";
            break;
        case "insane":
            dif.getElementsByTagName("IMG")[2].src = "ui/settings/mode_insane_selected.gif";
            break;
    }
        
    if (game_type == "2004") {
        writeString("info", "level: 1 score: 0", "grey");
        typ.getElementsByTagName("IMG")[1].src = "ui/settings/2004_selected.gif";
    } else {
        writeString("num_apples", "0", "grey");
        typ.getElementsByTagName("IMG")[0].src = "ui/settings/classic_selected.gif";
    }
        
    new_difficulty = difficulty;
    new_game_type = game_type;
        
    setDifficulty(difficulty);
        
    time_bar = document.getElementById("timer");			
}       
		
if (window.widget) {
    widget.onhide = function() {if (!isPaused && game_started) pauseGame(true);}
} 
        
window.onload = init;